unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus, RtRegc;

type
  TRtRegException = class(Exception);

  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    System1: TMenuItem;
    Exit1: TMenuItem;
    Delete1: TMenuItem;
    Lock1: TMenuItem;
    Registration1: TMenuItem;
    Registernow1: TMenuItem;
    N1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    RtRegControl1: TRtRegControl;
    procedure Exit1Click(Sender: TObject);
    procedure Lock1Click(Sender: TObject);
    procedure Registration1Click(Sender: TObject);
    procedure Registernow1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure RtRegControl1Register(Sender: TObject);
    procedure RtRegControl1StartCountLock(Sender: TObject);
    procedure RtRegControl1EndCountLock(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

const
  cRegVer	= 'DEMO Registered Version';
  cDemoVer	= 'DEMO Unregistered Version. You have %d more %s to try it out!';
  cPrg = 'DEMO';

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
	Unit2, Unit3, Unit4;

procedure TForm1.Exit1Click(Sender: TObject);
begin
	Close;
end;

procedure TForm1.Lock1Click(Sender: TObject);
begin
	with RtRegControl1 do begin
	   if IsCountLock then
   		DelCountLock
	   else if IsDateLock then
	   	DelDateLock;
   end;
end;

procedure TForm1.Registration1Click(Sender: TObject);
begin
 	RtRegControl1.DelRegistration;
end;

procedure TForm1.Registernow1Click(Sender: TObject);
begin
   if Register then
   begin
   	Caption := cRegVer;
      Registernow1.Enabled := False;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	with RtRegControl1 do begin
		if Registered then
	   begin
	      Caption := cRegVer;
	      Registernow1.Enabled := False;
	   end
	   else if IsCountLock then
	   	Caption := Format(cDemoVer,[CallsLeft,'times'])
	   else if IsDateLock then
	      Caption := Format(cDemoVer,[DaysLeft,'days']);
   end;
end;

procedure TForm1.About1Click(Sender: TObject);
var
	NewForm: TNewForm2;
begin
   NewForm := TNewForm2.Create(Application);
   try
   	NewForm.ShowModal;
   finally
   	NewForm.Free;
   end;
end;

procedure TForm1.RtRegControl1Register(Sender: TObject);
var
	Msg: string;
begin
   Msg := 'This an unregister version of the DEMO program.'+#13#10;
   with (Sender as TRtRegControl) do
   begin
		if CallsLeft>0 then
	      Msg := Msg+'You have '+IntToStr(CallsLeft)+' more calls to test it.'+#13#10
		else if DaysLeft>0 then
			Msg := Msg+'You have '+IntToStr(DaysLeft)+' more days to test it.'+#13#10;
		Msg := Msg+'Do you want to register now?';
  	 	if MessageDlg(Msg,mtConfirmation,[mbYes,mbNo],0)=idYes then
      	Unit2.Register;
   end;
end;

procedure TForm1.RtRegControl1StartCountLock(Sender: TObject);
begin
   with (Sender as TRtRegControl) do
		if not Registered then
      	SetLock;
end;

procedure TForm1.RtRegControl1EndCountLock(Sender: TObject);
var
	Msg: string;
begin
   with (Sender as TRtRegControl) do
   begin
	   Msg := 'This an unregister version of the DEMO program.'+#13#10+
	      	 'The evaluation period is over.'+#13#10+
				 'Do you want to register now?';
		if ((MessageDlg(Msg,mtConfirmation,[mbYes,mbNo],0)=idNo) or (not Unit2.Register)) then
      	raise TRtRegException.Create('The evaluation period is over.');
   end;
end;

end.
